
######################################################################
#
# Name:  addEnvVars
# Author:  Royal Render, Holger Schoenberger, Binary Alchemy
# Version: 
# Description: 
#   This plugin gets specific env vars that are available at submission and adds them to the job
#   It contains a blacklist as well. If you really need to copy all env vars and not specific ones, then use the blacklist to remove those env vars
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################


env_blacklist_win = \
[
    'Path',
    'TEMP',
    'TMP',
    #Windows10 (RR-Holger__Elliot)
    'ALLUSERSPROFILE',
    'APPDATA',
    'CommonProgramFiles',
    'CommonProgramFiles(x86)',
    'CommonProgramW6432',
    'COMPUTERNAME',
    'ComSpec',
    'CUDA_CACHE_MAXSIZE',
    'DriverData',
    'FPS_BROWSER_APP_PROFILE_STRING',
    'FPS_BROWSER_USER_PROFILE_STRING',
    'HOMEDRIVE',
    'HOMEPATH',
    'INTEL_DEV_REDIST',
    'LOCALAPPDATA',
    'LOGONSERVER',
    'NUMBER_OF_PROCESSORS',
    'PATHEXT',
    'PROCESSOR_ARCHITECTURE',
    'PROCESSOR_IDENTIFIER',
    'PROCESSOR_LEVEL',
    'PROCESSOR_REVISION',
    'ProgramData',
    'ProgramFiles',
    'ProgramFiles(x86)',
    'ProgramW6432',
    'PROMPT',
    'PSModulePath',
    'PUBLIC',
    'SESSIONNAME',
    'SystemDrive',
    'SystemRoot',
    'USERDOMAIN',
    'USERDOMAIN_ROAMINGPROFILE',
    'USERNAME',
    'USERPROFILE',
    'windir',
    #Windows11 (RR-Holger__RR-AYON__WIN)
    'OneDrive',
    'OS',
]


env_blacklist_lnx = \
[
    'PATH',
    'TEMP',
    'TMP',
    #Rocky 9.3 (RR-Holger__RR-AYON__LNX)
    'BASH_FUNC_which%%',
    'COLORTERM',
    'CUDA_CACHE_MAXSIZE',
    'DBUS_SESSION_BUS_ADDRESS',
    'DEBUGINFOD_IMA_CERT_PATH',
    'DEBUGINFOD_URLS',
    'DESKTOP_SESSION',
    'DISPLAY',
    'GDK_BACKEND',
    'GDMSESSION',
    'GDM_LANG',
    'GNOME_TERMINAL_SCREEN',
    'GNOME_TERMINAL_SERVICE',
    'HISTCONTROL',
    'HISTSIZE',
    'HOME',
    'HOSTNAME',
    'LANG',
    'LESSOPEN',
    'LOGNAME',
    'LS_COLORS',
    'MAIL',
    'PWD',
    'QT_IM_MODULE',
    'SESSION_MANAGER',
    'SHELL',
    'SHLVL',
    'SSH_AUTH_SOCK',
    'SYSTEMD_EXEC_PID',
    'TERM',
    'USER',
    'USERNAME',
    'VTE_VERSION',
    'WINDOWPATH',
    'XAUTHORITY',
    'XDG_CURRENT_DESKTOP',
    'XDG_DATA_DIRS',
    'XDG_MENU_PREFIX',
    'XDG_RUNTIME_DIR',
    'XDG_SESSION_CLASS',
    'XDG_SESSION_DESKTOP',
    'XDG_SESSION_TYPE',
    'XMODIFIERS',
    '_',
    'which_declare',
    
    #CentOS 7(RR-Holger__dev9)
    'GNOME_DESKTOP_SESSION_ID',
    'GNOME_SHELL_SESSION_MODE',
    'IMSETTINGS_INTEGRATE_DESKTOP',
    'IMSETTINGS_MODULE',
    'INFOPATH',
    'LD_LIBRARY_PATH',
    'MANPATH',
    'PCP_DIR',
    'PKG_CONFIG_PATH',
    'SSH_AGENT_PID',
    'XDG_SEAT',
    'XDG_SESSION_ID',
    'XDG_VTNR',

    #CentOS 8.2(RR-Holger__dev)
    'GJS_DEBUG_OUTPUT',
    'GJS_DEBUG_TOPICS',
    'WAYLAND_DISPLAY',

    #Ubuntu 20 (RR-Holger__test)
    'CLUTTER_IM_MODULE',
    'GPG_AGENT_INFO',
    'GTK_IM_MODULE',
    'GTK_MODULES',
    'IM_CONFIG_PHASE',
    'INVOCATION_ID',
    'JOURNAL_STREAM',
    'LC_ADDRESS',
    'LC_IDENTIFICATION',
    'LC_MEASUREMENT',
    'LC_MONETARY',
    'LC_NAME',
    'LC_NUMERIC',
    'LC_PAPER',
    'LC_TELEPHONE',
    'LC_TIME',
    'LESSCLOSE',
    'MANAGERPID',
    'QT4_IM_MODULE',
    'QT_ACCESSIBILITY',
    'XDG_CONFIG_DIRS',

]




env_blacklist_mac = \
[
    'PATH',
    'TEMP',
    'TMP',
    #Big Sur 11.6 (RR-Holger__Grisu)
    'TMPDIR',
    '__CFBundleIdentifier',
    'XPC_FLAGS',
    'XPC_SERVICE_NAME',
    'SSH_AUTH_SOCK',
    'TERM',
    'TERM_PROGRAM',
    'TERM_PROGRAM_VERSION',
    'TERM_SESSION_ID',
    'SHELL',
    'HOME',
    'LOGNAME',
    'USER',
    'SHLVL',
    'PWD',
    'OLDPWD',
    'HOMEBREW_PREFIX',
    'HOMEBREW_CELLAR',
    'HOMEBREW_REPOSITORY',
    'INFOPATH',
    'PYENV_SHELL',
    'LC_CTYPE',
    '_',
    #Sequonia 15.5 (RR-Holger__Grisu)
    'LaunchInstanceID',
    'SECURITYSESSIONID',

]



env_blacklist_RR = \
[
    'rrExeVer',
    'rrExeVerMajor',
    'rrExeVerMinor',
    'rrExeVerMinorRevision',
    'rrExeVerMinorRevision_NP',
    'rrExeVerMajorMinor',
    'rrExeOS',
    'rrExeBaseDir',
    'rrExeOSversion',
    'rrExeVersionFull',
    'rrExeVersionMinReq',
    'rrExeVersionMajor',
    'rrExeVersionMinorFull',
    'rrBaseAppPath',
    'rrJobRenderapp',
    'rrJobRenderer',
    'rrJobVer',
    'rrJobVerMajor',
    'rrJobVerMinor',
    'rrJobVerMajorMinor',
    'rrJobVerMinorRevision',
    'rrJobVerMinorRevision_NP',
    'rrJobRendererVersion',
    'rrJobRendererVersionMajor',
    'rrJobProject',
    'rrJobUser',
    'rrJobType',
    'rrJobTiled',
    'rrJobCustomScene',
    'rrJobCustomSequence',
    'rrJobCustomShot',
    'rrJobCustomVersion',
    'rrJobSceneOS',
    'rrJobVersion',
    'rrJobVersionFull',
    'rrJobVersionMajor',
    'rrJobVersionMinorFull',
    'rrClientName',
    'rrClientCores',
    'rrClientCoresPhysical',
    'rrClientCoresUsed',
    'rrClientRamMaxAllowed',
    'rrClientRamAvail',
    'rrClientRunMode',
    'GPUactive',
    'GpuListC',
    'GPUsInstalledList',
    'rrClientBit',
    'rrClientRenderInstance',
    'rrClientThreadID',
    'rrClientThreadIDstr',
    'rrClientGroups',
    'cfgLicPool',
    'cfgPreset',
    'rrOS',
    'RR_ROOT',
    'rrBin',
    'rrPlugins',
    'rrPluginsNoOS',
    'rrPrefs',
    'rrSharedExeDir',
    'rrLocalTemp',
    'TEMP',
    'TMP',
    'TMPDIR',
    'rrLocalRoot',
    'rrLocalExeDir',
    'rrLocalPrefs',
    'rrLocalPlugins',
]

env_blacklist_allOS = list(set(env_blacklist_win + env_blacklist_lnx + env_blacklist_mac + env_blacklist_RR))







envListVar=[]
envListValue=[]

envName='ShotSetting'
if (envName in os.environ):
    envListVar.append(envName)
    envListValue.append(os.environ[envName])

envName='OCIO_settingXY'
if (envName in os.environ):
    envListVar.append(envName)
    envListValue.append(os.environ[envName])
    




#exit if no env var has been found
if (len(envListVar)==0):
    raise rrCleanExit()

rrEnvList=""
#create rrEnvlist format
for i in range(len(envListVar)):
    rrEnvList= rrEnvList + envListVar[i] + "=" + envListValue[i] + " ~~~ "

rrGlobal.writeLog2(rrGlobal.logLvL.warning, "Adding env var list:\n"+rrEnvList)

for jNr in range(0, rr.jobSelected_count()):
    job= rr.jobSelected_get(jNr)
    job.customDataAppend_Str("rrEnvList", rrEnvList)
    rr.jobSelected_set(jNr,job)
